(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     54859,       1629]*)
(*NotebookOutlinePosition[     55761,       1659]*)
(*  CellTagsIndexPosition[     55717,       1655]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["First-Order Linear"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Theory"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Given continuous functions p[x] and q[x], find all solutions of the \
first-order linear differential equation \n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\
\ty'[x] + p[x] y[x] == q[x].\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nFirst define \
the function    \n(1)\t\t",
  StyleBox["Mu[x_] = Exp[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(p[x]\),
              FontWeight->"Bold"], 
            StyleBox[\(\[DifferentialD]x\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  ". \nThen multiply through the differential equation by Mu[x]. This gives:\n\
\t\tMu[x](y'[x] + p[x] y[x]) = ",
  Cell[BoxData[
      \(TraditionalForm\`d\/dx\)]],
  "(Mu[x] y[x]) == Mu[x] q[x].\nIntegrate both sides of \n\t \t",
  Cell[BoxData[
      \(TraditionalForm\`d\/dx\)]],
  "(Mu[x] y[x]) = Mu[x] q[x]\nto get\n(2)\t\t",
  StyleBox["Mu[x] y[x] =",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Integral]",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(Mu[x]\),
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox[\(q[x]\),
              FontWeight->"Bold"], 
            StyleBox[\(\[DifferentialD]x\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  StyleBox[" + c",
    FontWeight->"Bold"],
  "\nFinally, divide through by the non-zero function Mu[x] to get the \
complete solution:\n(3)\t\t",
  StyleBox["y[x_] = ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(1\/Mu[x]\),
          FontWeight->"Bold"], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]Mu[x]\ q[x] \[DifferentialD]x\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" + ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(c\/Mu[x]\),
          FontWeight->"Bold"], TraditionalForm]]],
  ".\n\nThis function is a solution for each choice of the constant  c. This \
solution should be checked by substituting it into the differential equation; \
the result should be identically true. Let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " do the check for you. Do the steps manually to get a better feel for what \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has done for you."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Notes on implementing the theory"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Several of the equations above have algebraic expressions (rather than \
variables) on the left-hand side. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " wants a variable on the left when doing a substitution (defining the \
variable).Thus, the above theory cannot be rendered ",
  StyleBox["exactly",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " as it is stated.  To remedy this situation, we execute those expressions \
that appear in ",
  StyleBox["bold face",
    FontWeight->"Bold"],
  " in the paragraph above. \n\nBe alert to where each of these ",
  StyleBox["bold face",
    FontWeight->"Bold"],
  " expressions is defined in the example below. They are numbered for easy \
reference."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Example: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\(y'\)[x]\),
              "Input"], 
            StyleBox[" ",
              "Input"], 
            StyleBox["+",
              "Input"], 
            StyleBox[" ",
              "Input"], 
            RowBox[{
              StyleBox["3",
                "Input"], 
              StyleBox[" ",
                "Input"], \(y[x]\)}]}], "==", \(x\^2\)}], TraditionalForm]]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
 Define p[x] and q[x] of  y'[x] + p[x] y[x] == q[x], the \
differential equation.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[x_] = 3\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(q[x_] = x\^2\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is the differential equation ",
  StyleBox["y'[x] + p[x] y[x] == q[x]", "Input"],
  " that you defined. Make sure that it is correct.  (This example should \
read ",
  StyleBox["y'[x] + 3 y[x] == x^2", "Input"],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "+", \(p[x]\ y[x]\)}], 
      "==", \(q[x]\)}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{\(3\ y[x]\), "+", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], 
      "==", \(x\^2\)}]], "Output"]
}, Closed]],

Cell[TextData[" Here is how to integrate p[x] with respect to x."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]p[x] \[DifferentialD]x\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\ x\)], "Output"]
}, Closed]],

Cell[TextData[" Define the function Mu[x]. This is step (1) above."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Mu[x_] = Exp[\[Integral]p[x] \[DifferentialD]x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(3\ x\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  " Define the expression in the ",
  StyleBox["bold",
    FontWeight->"Bold"],
  " part of step (2) above."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(SolnPart = \[Integral]\(Mu[x]\ q[x]\) \[DifferentialD]x + c\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(c + \[ExponentialE]\^\(3\ x\)\ \((2\/27 - \(2\ x\)\/9 + 
            x\^2\/3)\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  " Define the solution function defined above in step (3). Here this \
solution is called ",
  StyleBox["Soln",
    FontWeight->"Bold"],
  ". The function ",
  StyleBox["Expand",
    FontWeight->"Bold"],
  " is used to make the expression simpler (if possible, as it is here)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Soln[x_] = Expand[SolnPart\/Mu[x]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\/27 + c\ \[ExponentialE]\^\(\(-3\)\ x\) - \(2\ x\)\/9 + 
      x\^2\/3\)], "Output"]
}, Closed]],

Cell[TextData[
" Check the solution. (First attempt: note that we need to multiply out the \
expressions that appear.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["Soln", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], 
      "+", \(p[x]\ Soln[x]\)}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-\(2\/9\)\) - 3\ c\ \[ExponentialE]\^\(\(-3\)\ x\) + \(2\ x\)\/3 + 
      3\ \((2\/27 + c\ \[ExponentialE]\^\(\(-3\)\ x\) - \(2\ x\)\/9 + 
            x\^2\/3)\)\)], "Output"]
}, Closed]],

Cell[TextData[
" Check the solution again, this time multiplying out the expressions that \
appear. We now get the original right hand side."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Expand", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["Soln", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "+", \(p[x]\ Soln[x]\)}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Check the solution in one step. Here we let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expand out both sides and compare them. Since they are equal, the result \
is ",
  StyleBox["True",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExpandAll", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["Soln", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "+", \(p[x]\ Soln[x]\)}], "==", \(q[x]\)}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[" Make a Table of solutions and Plot them"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(t = Table[Soln[x], {c, \(-3\), 3, 1\/2}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[t], {x, \(-1\), 2}]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.2811 0.105532 [
[.02381 .2686 -6 -9 ]
[.02381 .2686 6 0 ]
[.18254 .2686 -12 -9 ]
[.18254 .2686 12 0 ]
[.5 .2686 -9 -9 ]
[.5 .2686 9 0 ]
[.65873 .2686 -3 -9 ]
[.65873 .2686 3 0 ]
[.81746 .2686 -9 -9 ]
[.81746 .2686 9 0 ]
[.97619 .2686 -3 -9 ]
[.97619 .2686 3 0 ]
[.32877 .07004 -12 -4.5 ]
[.32877 .07004 0 4.5 ]
[.32877 .17557 -12 -4.5 ]
[.32877 .17557 0 4.5 ]
[.32877 .38663 -6 -4.5 ]
[.32877 .38663 0 4.5 ]
[.32877 .49216 -6 -4.5 ]
[.32877 .49216 0 4.5 ]
[.32877 .5977 -6 -4.5 ]
[.32877 .5977 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .2811 m
.02381 .28735 L
s
[(-1)] .02381 .2686 0 1 Mshowa
.18254 .2811 m
.18254 .28735 L
s
[(-0.5)] .18254 .2686 0 1 Mshowa
.5 .2811 m
.5 .28735 L
s
[(0.5)] .5 .2686 0 1 Mshowa
.65873 .2811 m
.65873 .28735 L
s
[(1)] .65873 .2686 0 1 Mshowa
.81746 .2811 m
.81746 .28735 L
s
[(1.5)] .81746 .2686 0 1 Mshowa
.97619 .2811 m
.97619 .28735 L
s
[(2)] .97619 .2686 0 1 Mshowa
.125 Mabswid
.05556 .2811 m
.05556 .28485 L
s
.0873 .2811 m
.0873 .28485 L
s
.11905 .2811 m
.11905 .28485 L
s
.15079 .2811 m
.15079 .28485 L
s
.21429 .2811 m
.21429 .28485 L
s
.24603 .2811 m
.24603 .28485 L
s
.27778 .2811 m
.27778 .28485 L
s
.30952 .2811 m
.30952 .28485 L
s
.37302 .2811 m
.37302 .28485 L
s
.40476 .2811 m
.40476 .28485 L
s
.43651 .2811 m
.43651 .28485 L
s
.46825 .2811 m
.46825 .28485 L
s
.53175 .2811 m
.53175 .28485 L
s
.56349 .2811 m
.56349 .28485 L
s
.59524 .2811 m
.59524 .28485 L
s
.62698 .2811 m
.62698 .28485 L
s
.69048 .2811 m
.69048 .28485 L
s
.72222 .2811 m
.72222 .28485 L
s
.75397 .2811 m
.75397 .28485 L
s
.78571 .2811 m
.78571 .28485 L
s
.84921 .2811 m
.84921 .28485 L
s
.88095 .2811 m
.88095 .28485 L
s
.9127 .2811 m
.9127 .28485 L
s
.94444 .2811 m
.94444 .28485 L
s
.25 Mabswid
0 .2811 m
1 .2811 L
s
.34127 .07004 m
.34752 .07004 L
s
[(-2)] .32877 .07004 1 0 Mshowa
.34127 .17557 m
.34752 .17557 L
s
[(-1)] .32877 .17557 1 0 Mshowa
.34127 .38663 m
.34752 .38663 L
s
[(1)] .32877 .38663 1 0 Mshowa
.34127 .49216 m
.34752 .49216 L
s
[(2)] .32877 .49216 1 0 Mshowa
.34127 .5977 m
.34752 .5977 L
s
[(3)] .32877 .5977 1 0 Mshowa
.125 Mabswid
.34127 .09114 m
.34502 .09114 L
s
.34127 .11225 m
.34502 .11225 L
s
.34127 .13336 m
.34502 .13336 L
s
.34127 .15446 m
.34502 .15446 L
s
.34127 .19667 m
.34502 .19667 L
s
.34127 .21778 m
.34502 .21778 L
s
.34127 .23889 m
.34502 .23889 L
s
.34127 .25999 m
.34502 .25999 L
s
.34127 .30221 m
.34502 .30221 L
s
.34127 .32331 m
.34502 .32331 L
s
.34127 .34442 m
.34502 .34442 L
s
.34127 .36553 m
.34502 .36553 L
s
.34127 .40774 m
.34502 .40774 L
s
.34127 .42884 m
.34502 .42884 L
s
.34127 .44995 m
.34502 .44995 L
s
.34127 .47106 m
.34502 .47106 L
s
.34127 .51327 m
.34502 .51327 L
s
.34127 .53438 m
.34502 .53438 L
s
.34127 .55548 m
.34502 .55548 L
s
.34127 .57659 m
.34502 .57659 L
s
.34127 .04893 m
.34502 .04893 L
s
.34127 .02782 m
.34502 .02782 L
s
.34127 .00672 m
.34502 .00672 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.35272 0 m
.37838 .06372 L
.39737 .09955 L
.41809 .13212 L
.45874 .18073 L
.49787 .21383 L
.53945 .23933 L
.57952 .25781 L
.61807 .27206 L
.65907 .28498 L
.69856 .29626 L
.73653 .30669 L
.77695 .31783 L
.81586 .32891 L
.85722 .34131 L
.89707 .35403 L
.9354 .36708 L
.97618 .38193 L
.97619 .38194 L
s
.3318 0 m
.33961 .02104 L
.37838 .10087 L
.39737 .1306 L
.41809 .15765 L
.45874 .19811 L
.49787 .22584 L
.53945 .24744 L
.57952 .26336 L
.61807 .27592 L
.65907 .2876 L
.69856 .29807 L
.73653 .30795 L
.77695 .31869 L
.81586 .3295 L
.85722 .34171 L
.89707 .3543 L
.9354 .36728 L
.97618 .38207 L
.97619 .38207 L
s
.30746 0 m
.32036 .03345 L
.33961 .07464 L
.37838 .13803 L
.39737 .16166 L
.41809 .18318 L
.45874 .2155 L
.49787 .23786 L
.53945 .25555 L
.57952 .26892 L
.61807 .27978 L
.65907 .29022 L
.69856 .29987 L
.73653 .30921 L
.77695 .31955 L
.81586 .3301 L
.85722 .34211 L
.89707 .35458 L
.9354 .36747 L
.97618 .3822 L
.97619 .3822 L
s
.27553 0 m
.2787 .00897 L
.29932 .05733 L
.32036 .09774 L
.33961 .12824 L
.37838 .17519 L
.39737 .19271 L
.41809 .20871 L
.45874 .23289 L
.49787 .24987 L
.53945 .26366 L
.57952 .27447 L
.61807 .28364 L
.65907 .29284 L
.69856 .30167 L
.73653 .31047 L
.77695 .32041 L
.81586 .33069 L
.85722 .34251 L
.89707 .35485 L
.9354 .36766 L
.97618 .38233 L
.97619 .38233 L
s
.2315 0 m
.25997 .0697 L
.2787 .10428 L
.29932 .13576 L
.32036 .16203 L
.33961 .18184 L
.37838 .21234 L
.39737 .22376 L
.41809 .23424 L
.45874 .25028 L
.49787 .26188 L
.53945 .27177 L
.57952 .28002 L
.61807 .2875 L
.65907 .29546 L
.69856 .30347 L
.73653 .31173 L
.77695 .32127 L
.81586 .33129 L
.85722 .34292 L
.89707 .35513 L
.9354 .36785 L
.97618 .38246 L
.97619 .38246 L
s
.15258 0 m
.16305 .02887 L
.18163 .07108 L
.20239 .10988 L
.22156 .13921 L
.25997 .18347 L
.2787 .19959 L
.29932 .2142 L
.32036 .22632 L
.33961 .23544 L
.37838 .2495 L
.41809 .25977 L
.45628 .26724 L
.49693 .27376 L
.53606 .2794 L
.57764 .28531 L
.61771 .2913 L
.65626 .29759 L
.69726 .30503 L
.73675 .31304 L
.77472 .3216 L
.81515 .33169 L
.85405 .3424 L
.89542 .35488 L
.93526 .368 L
.97359 .38163 L
.97619 .38259 L
s
.02381 .34755 m
.06244 .33665 L
.10458 .32596 L
.14415 .31704 L
.18221 .3095 L
.22272 .30258 L
.26171 .297 L
.30316 .29224 L
.32392 .2903 L
.34309 .28878 L
.36292 .28748 L
.3815 .28651 L
.40022 .28578 L
.41016 .28548 L
.4157 .28535 L
.42085 .28525 L
.42615 .28516 L
.43095 .2851 L
.43352 .28507 L
.43629 .28505 L
.43782 .28504 L
.43922 .28503 L
.44056 .28502 L
.44198 .28502 L
.44324 .28501 L
.44439 .28501 L
.44555 .28501 L
.44664 .28501 L
.44791 .28501 L
.44909 .28501 L
.45038 .28501 L
.45103 .28501 L
.45175 .28502 L
.45432 .28503 L
.45576 .28504 L
.45708 .28504 L
.46207 .28509 L
.46681 .28514 L
.47188 .28522 L
.481 .28541 L
.49184 .28571 L
.5017 .28605 L
.52088 .28691 L
.54168 .28813 L
.5826 .29142 L
.622 .29569 L
.65989 .30081 L
.70023 .30738 L
.73905 .31476 L
.78033 .32377 L
Mistroke
.82009 .33357 L
.85834 .34404 L
.89903 .3563 L
.93822 .3692 L
.97619 .38272 L
Mfstroke
.15772 .61803 m
.18163 .54813 L
.20293 .50084 L
.22307 .46375 L
.26149 .40918 L
.28133 .38758 L
.30236 .36854 L
.34019 .3423 L
.3596 .33205 L
.38048 .32299 L
.40019 .31601 L
.4217 .30991 L
.44229 .30533 L
.46141 .30203 L
.47198 .30057 L
.48193 .2994 L
.50054 .29772 L
.5103 .29708 L
.51564 .29681 L
.52062 .29659 L
.52522 .29642 L
.52942 .29629 L
.53409 .29618 L
.53666 .29614 L
.53909 .2961 L
.54146 .29607 L
.54254 .29607 L
.54368 .29606 L
.54495 .29605 L
.54612 .29605 L
.54737 .29604 L
.54808 .29604 L
.54874 .29604 L
.54939 .29604 L
.55008 .29605 L
.55134 .29605 L
.55257 .29606 L
.5537 .29606 L
.55628 .29609 L
.559 .29612 L
.56353 .2962 L
.56777 .2963 L
.57742 .2966 L
.58783 .29706 L
.59771 .2976 L
.61624 .29892 L
.65449 .30276 L
.69519 .30835 L
.73437 .3151 L
.776 .32364 L
Mistroke
.81612 .33314 L
.85473 .34342 L
.89578 .35556 L
.93532 .3684 L
.97334 .38181 L
.97619 .38285 L
Mfstroke
.22588 .61803 m
.25997 .52476 L
.2787 .48553 L
.29932 .4495 L
.32036 .4192 L
.33961 .39624 L
.37838 .36097 L
.39737 .34798 L
.41809 .33636 L
.43941 .32678 L
.45874 .31983 L
.47912 .31405 L
.49787 .30994 L
.51711 .30675 L
.52724 .30545 L
.53793 .30434 L
.54741 .30357 L
.55263 .30322 L
.55757 .30294 L
.56216 .30272 L
.56716 .30252 L
.5717 .30239 L
.57591 .30229 L
.57832 .30225 L
.58054 .30223 L
.5817 .30221 L
.58297 .3022 L
.58361 .3022 L
.5843 .3022 L
.58553 .30219 L
.5867 .30219 L
.58797 .30219 L
.58916 .30219 L
.59027 .3022 L
.59126 .3022 L
.59236 .30221 L
.59457 .30223 L
.59725 .30227 L
.5997 .30232 L
.60521 .30245 L
.61032 .30261 L
.61517 .3028 L
.62478 .30327 L
.63502 .30391 L
.65342 .30539 L
.67487 .30763 L
.69505 .3102 L
.73365 .31626 L
.77471 .32423 L
.81425 .33327 L
Mistroke
.85227 .34316 L
.89275 .35491 L
.93171 .36738 L
.97312 .38186 L
.97619 .38298 L
Mfstroke
.26662 .61803 m
.2787 .58084 L
.29932 .52793 L
.32036 .48349 L
.33961 .44984 L
.37838 .39813 L
.39737 .37903 L
.41809 .3619 L
.43941 .34765 L
.45874 .33722 L
.47912 .32839 L
.49787 .32195 L
.51711 .31677 L
.53793 .31257 L
.55676 .30987 L
.56744 .30874 L
.57742 .30793 L
.58243 .30761 L
.58787 .30732 L
.59301 .30711 L
.59777 .30695 L
.60205 .30686 L
.60448 .30681 L
.60677 .30679 L
.60794 .30678 L
.60917 .30677 L
.61022 .30676 L
.61137 .30676 L
.61261 .30676 L
.61331 .30676 L
.61394 .30676 L
.61517 .30676 L
.61633 .30677 L
.61748 .30678 L
.61872 .30679 L
.62096 .30682 L
.62362 .30687 L
.62605 .30692 L
.63133 .30707 L
.63634 .30725 L
.64517 .30766 L
.6548 .30825 L
.67451 .30985 L
.69549 .31211 L
.73713 .31813 L
.77725 .32563 L
.81585 .33426 L
.8569 .34484 L
.89644 .35632 L
.93447 .3685 L
Mistroke
.97494 .38266 L
.97619 .38312 L
Mfstroke
.29588 .61803 m
.29932 .60637 L
.32036 .54778 L
.33961 .50344 L
.37838 .43528 L
.39737 .41009 L
.41809 .38743 L
.43941 .36852 L
.45874 .35461 L
.49787 .33396 L
.51711 .32678 L
.53793 .3208 L
.55787 .31655 L
.56791 .31489 L
.57894 .31341 L
.58914 .31233 L
.59845 .31158 L
.60359 .31125 L
.60919 .31096 L
.61447 .31075 L
.61702 .31067 L
.61936 .31061 L
.62157 .31056 L
.62399 .31052 L
.62517 .31051 L
.62643 .31049 L
.62712 .31049 L
.62775 .31048 L
.62899 .31048 L
.63015 .31047 L
.63122 .31047 L
.63239 .31047 L
.63364 .31048 L
.63472 .31048 L
.63573 .31049 L
.63803 .31051 L
.6393 .31053 L
.64069 .31055 L
.64322 .3106 L
.64796 .31073 L
.65349 .31092 L
.65863 .31115 L
.66922 .31175 L
.67919 .31247 L
.69781 .31421 L
.73641 .31927 L
.77747 .32653 L
.81701 .33513 L
.85503 .34474 L
.89551 .35632 L
Mistroke
.93447 .3687 L
.97588 .38313 L
.97619 .38325 L
Mfstroke
.31864 .61803 m
.32036 .61208 L
.33961 .55704 L
.37838 .47244 L
.39737 .44114 L
.41809 .41296 L
.43941 .38939 L
.45874 .372 L
.49787 .34598 L
.51711 .3368 L
.53793 .32902 L
.55787 .32336 L
.56804 .32106 L
.57894 .319 L
.58921 .3174 L
.59857 .31621 L
.60799 .31526 L
.61691 .31458 L
.62189 .31428 L
.62656 .31405 L
.63144 .31387 L
.63403 .3138 L
.63682 .31373 L
.63905 .31369 L
.64033 .31367 L
.6415 .31366 L
.64273 .31365 L
.64405 .31364 L
.64527 .31363 L
.64643 .31363 L
.6475 .31363 L
.64863 .31364 L
.64959 .31364 L
.65065 .31365 L
.6518 .31366 L
.65302 .31367 L
.65524 .31371 L
.65778 .31376 L
.66049 .31382 L
.66537 .31398 L
.67116 .31421 L
.67641 .31448 L
.69651 .31591 L
.7158 .31787 L
.73663 .32056 L
.77769 .32743 L
.81723 .33577 L
.85525 .34521 L
.89573 .35666 L
.93469 .36896 L
Mistroke
.9761 .38335 L
.97619 .38338 L
Mfstroke
.33745 .61803 m
.33961 .61064 L
.37838 .5096 L
.39737 .4722 L
.41809 .43849 L
.43941 .41027 L
.45874 .38939 L
.49787 .35799 L
.51711 .34681 L
.53793 .33725 L
.55787 .33018 L
.57894 .32458 L
.58841 .32261 L
.59857 .32085 L
.6081 .31949 L
.61691 .31848 L
.62708 .31757 L
.63245 .31721 L
.63815 .3169 L
.64308 .31669 L
.64771 .31655 L
.65036 .31649 L
.65279 .31645 L
.65407 .31643 L
.65546 .31642 L
.65616 .31642 L
.65692 .31641 L
.65762 .31641 L
.65827 .31641 L
.65946 .31641 L
.66058 .31641 L
.6618 .31641 L
.66312 .31642 L
.66378 .31643 L
.66449 .31643 L
.6658 .31645 L
.66825 .31649 L
.67056 .31654 L
.67303 .3166 L
.67745 .31674 L
.68308 .31697 L
.68837 .31724 L
.69825 .31788 L
.71837 .31967 L
.73685 .32185 L
.77639 .32804 L
.81442 .33573 L
.85489 .34553 L
.89386 .35639 L
.93527 .36935 L
Mistroke
.97517 .38314 L
.97619 .38351 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003o:oooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool0/oooool0
02_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool01?ooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo
0;?ooooo000[ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Cooooo0ol00003ooooo`03o`000?oooooooooo0;;o
oooo000/ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`03o`000?oooooooooo0;;ooooo
000/ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`03o`000?oooooooooo0;;ooooo000/
ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2a
ooooo`00;?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0/Oooool002gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo0;3ooooo000]ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`03o`00
0?oooooooooo0;3ooooo000]ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`03o`000?oo
oooooooo0;3ooooo000^ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000001Oooool0
0ol0003oooooooooo`2_ooooo`00;_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo0000
00Gooooo00?o0000ooooooooool0[oooool002oooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Kooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0[oooool002oooooo00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Kooooo00Go0000oooooooo
ooooooooo`000002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0[_ooool0033o
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0[_ooool0033ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo0:gooooo000aooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`2]ooooo`00<Oooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooool000001?l00002ooooo`03o`000?oooooo000000Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`2]ooooo`00<_ooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooool000000_ooool01_l0003oooooooooool0
003oooooo`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2/ooooo`00<_oo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo1_l00002ooooo`03o`000?oo
oooooooo00?ooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0[?oo
ool003?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0:ooooo`04o`000?oooooo
ooooo`0000Cooooo1?l00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Zooo
ool003?ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0:ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0Zoooool003Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`09
ooooo`;o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Zooooo`00=?ooool00ol0003oooooooooo`0Coooo
o`03o`000?oooooooooo00[ooooo0ol00005ooooo`;o00001_ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0:[ooooo000eooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000Gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`2Yooooo`00=Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooo`000006ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0ZOooool003Kooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo0_l000000ooooooo0000oooo
o`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Z?ooool003Oooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Co0000
oooooooooooo00001_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:Sooooo000g
ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0:Oooooo000hooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:Oooooo000hooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:Kooooo000ioooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02oooool01?l0003oooooooooool00005
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2U
ooooo`00>Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool00_l00004ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2Uooooo`00>_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooool000001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0Y?ooool003_ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo0:?ooooo000kooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool02_ooool2o`0000Oooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo0:?ooooo000looooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Rooooo`00??ooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0XOooool003gooooo00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`08ooooo`;o00002?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0XOooool003kooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Sooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:3ooooo000nooooo`03o`000?oo
oooooooo01Cooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00007ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Oooooo`00?ooo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Kooooo00Go0000oooooooooooooooo
o`000007ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`2Nooooo`00@?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`2Mooooo`00@Oooool00ol0003oooooooooo`0C
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2M
ooooo`00@_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo0_l00004oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo09cooooo0013ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo0014ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo09[ooooo0014ooooo`03o`000?oooooooooo013ooooo0ol000000ooooooo0000oooo
o`02ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0V_ooool004Gooooo00?o0000
ooooooooool04?ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`2Iooooo`00A_ooool00ol0003oooooooooo`07ooooo`Go00000oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooo000000[ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0V?ooool0
04Oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`Co00002Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2Gooooo`00B?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Co
oooo0_l0000;ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`02ooooo`;o0000Uoooool004Wooooo0_l0000<ooooo`;o00001_ooool00ol0003ooooo
o`00000;ooooo`03o`000?oooooooooo00Gooooo0_l00005ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0U?ooool004_ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`04ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Toooool004cooooo00?o
0000ooooooooool04?ooool01Ol0003ooooooooooooooooo000000_ooooo0_l00007ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Booooo`00COoo
ool00ol0003oooooooooo`0?ooooo`;o00000oooool2o`0000_ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo0_l0002Booooo`00C_ooool2
o`0000oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Gooooo0_l00004ooooo`;o00001Oooool00ol0003oooooooooo`2?ooooo`00D?ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`2>ooooo`00DOooool2o`0000cooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo08gooooo001Cooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`;o00001oooool00ol0003ooooo
ooooo`03ooooo`;o00001?ooool00ol0003oooooooooo`2<ooooo`00E?ooool2o`0000Wooooo00?o
0000ooooooooool02?ooool2o`0000_ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00;ooooo0_l0002<ooooo`00E_ooool00ol0003oooooooooo`06
ooooo`;o00002oooool2o`0000[ooooo0_l00006ooooo`;o00001Oooool2o`0000Cooooo0_l0002:
ooooo`00Eoooool2o`0000Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`09oooo
o`;o00001_ooool2o`0000Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`27oooo
o`00FOooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo0_l0000;ooooo`03
o`000?oooooooooo00Gooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0_l00027ooooo`00
F_ooool2o`0000?ooooo00?o0000ooooooooool03oooool2o`0000[ooooo0_l00007ooooo`03o`00
0?oooooooooo00;ooooo0_l00005ooooo`;o0000QOooool005cooooo1?l0000Cooooo`;o00002_oo
ool00ol0003oooooooooo`05ooooo`;o00001?ooool2o`0000Gooooo00?o0000ooooooooool0P_oo
ool005oooooo0_l0000Dooooo`;o00002Oooool2o`0000Oooooo0_l00004ooooo`;o00001?ooool2
o`0008;ooooo001Oooooo`Go00004oooool3o`0000Sooooo0ol00006ooooo`;o00001?ooool2o`00
00Cooooo0_l00020ooooo`001oooool3o`0002Gooooo0_l00004ooooo`03o`000?oooooooooo00;o
oooo0ol0000Rooooo`03o`000?oooooooooo00;ooooo0ol0000Cooooo`?o00002?ooool3o`0000?o
oooo00?o0000ooooool000001ol00004ooooo`;o00006oooool3o`0002Cooooo0ol00004ooooo`03
o`000?oooooooooo00;ooooo0ol0000Rooooo`Go00001_ooool000Sooooo00?o0000ooooooooool0
8oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000008Oooool00ol0
003oooooooooo`05ooooo`?o00004oooool3o`0000Cooooo00?o0000ooooooooool01?l00004oooo
o`?o000000?oooooo`000?ooool00_l00004ooooo`;o00006_ooool00ol0003oooooooooo`0Toooo
o`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Rooooo`04o`000?oooooo
ooooo`0000Kooooo0005o`0000?ooooo00?o0000ooooooooool07?ooool5o`0000;ooooo00Co0000
oooooooooooo00002oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Sooooo0ol0
000Cooooo`;o00000_ooool01?l0003oooooooooool00003ooooo`?o00001?ooool2o`0000?ooooo
0_l00004ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool09?ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool01_ooool000Sooooo00?o
0000ooooooooool08oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo01oooooo
00?o0000ooooooooool02oooool4o`00017ooooo0ol00002ooooo`03o`000?oooooooooo00Cooooo
0ol00002ooooo`Co00000_ooool3o`0000;ooooo0_l0000Gooooo`03o`000?oooooooooo02Cooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Gooooo
0008ooooo`03o`000?oooooooooo02?ooooo00Co0000oooooooooooo00001oooool4o`0002;ooooo
00?o0000ooooooooool03oooool3o`00013ooooo1?l00007ooooo`Go00000oooool2o`0000?ooooo
0ol000000ooooooo0000o`00000Eooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0
1oooool4o`0002;ooooo00Go0000ooooooooooooooooo`000006ooooo`001oooool2o`0002Gooooo
00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0Sooooo`;o00004oooool5o`0000_o
oooo00?o0000ooooooooool01?l00004ooooo`03o`000?oooooooooo00;ooooo0ol00002ooooo`?o
00000oooool5o`0001;ooooo0_l0000Uooooo`;o00002Oooool00ol0003oooooooooo`0Sooooo`05
o`000?ooooooooooooooool000001_ooool000Sooooo00?o0000ooooooooool09?ooool2o`0000So
oooo1Ol0000Qooooo`03o`000?oooooooooo01Oooooo1Ol00007ooooo`;o00001?ooool9o`0000?o
oooo0ol00002ooooo`?o00000oooool5o`00013ooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`07ooooo`Go00008_ooool3o`0000Oooooo001Oooooo`03o`000?oooooooooo01cooooo
1_l0000;ooooo`Ko00001Oooool4o`000004ooooool0003o0000o`0000;ooooo1_l0001_ooooo`00
Goooool00ol0003oooooooooo`0Rooooo`Go00003?ooool5o`0000Cooooo0ol000001?oooooo0000
o`000?l00002ooooo`Ko0000K?ooool005oooooo00?o0000ooooooooool09oooool6o`0000_ooooo
1?l00003ooooo`So000000?oooooo`000?l000001?l0001Yooooo`00Goooool00ol0003ooooooooo
o`0]ooooo`Go00002_ooool3o`0000Cooooo1ol000000ooooooo0000o`000005o`0006Gooooo003o
o`0001[o00000006ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`03ooooob;o00001Oooool00ol0003oooooooooo`05ooooo`ko000000?oooooo`00
0?l000003Ol00006ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo0006ooooo`03o`000?oooooooooo02[o
oooo00?o0000ooooooooool0:?ooool@o`0001kooooo00Co0000oooooooooooooooo3ol00007oooo
oaWo00009_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo001Booooo`co
000000?oooooo`000?ooool0?_ooool;o`000003ooooool0003o000001Ko0000E_ooool004cooooo
1_l0000=ooooo`03o`000?oooooooooo02kooooo5Ol00005oooooago0000D_ooool004Cooooo2?l0
000Cooooo`03o`000?oooooooooo02Cooooo2_l0000EooooobGo0000Coooool003_ooooo2Ol0000K
ooooo`;o00007_ooool7o`0001;ooooo:Ol000000ooooooo0000o`000009o`0004cooooo000foooo
o`Go00009?ooool00ol0003oooooooooo`0Gooooo`Ko00003oooool:o`0000cooooo4Ol000000ooo
oooo0000o`00000Io`0004Sooooo000`ooooo`Ko0000:Oooool00ol0003oooooooooo`0Cooooo`Co
00004?ooool5o`0000cooooo2_l00006ooooob_o0000A?ooool002_ooooo1Ol0000_ooooo`03o`00
0?oooooooooo013ooooo0ol0000@ooooo`Co00002oooool6o`0000Oooooo2Ol00002ooooobgo0000
@?ooool002Kooooo1Ol0000dooooo`03o`000?oooooooooo00gooooo0ol0000@ooooo`?o00002ooo
ool4o`0000Kooooo1ol00003ooooo`So00000oooool^o`0003cooooo000Rooooo`Co0000>Oooool0
0ol0003oooooooooo`0:ooooo`?o00004?ooool3o`0000_ooooo0ol00006ooooo`Co00001?ooool6
o`0000?ooooo2?l0000HoooooaWo0000>Oooool001oooooo0ol0000mooooo`;o00002?ooool3o`00
013ooooo0ol0000:ooooo`Co00001_ooool3o`0000Gooooo0ol00003ooooo`Ko00009_oooolFo`00
03Kooooo000Kooooo`Co0000@?ooool00ol0003oooooooooo`04ooooo`?o00004Oooool2o`0000Wo
oooo1?l00007ooooo`?o00001Oooool3o`0000?ooooo0ol0000doooooa;o0000<_ooool001Oooooo
1?l00014ooooo`03o`000?oooooooooo00;ooooo0_l0000Booooo`;o00002Oooool2o`0000Sooooo
0ol00006ooooo`;o00000oooool3o`0003oooooo3Ol0000_ooooo`004oooool4o`0004Sooooo00?o
0000ooooooooool00_l0000Booooo`;o00002Oooool2o`0000Oooooo0ol00006ooooo`?o00000_oo
ool3o`0004Oooooo2ol0000/ooooo`003oooool4o`0004cooooo0ol0000Booooo`;o00002Oooool2
o`0000Oooooo0_l00006ooooo`?o00000oooool2o`0004oooooo2Ol0000Yooooo`002oooool4o`00
04oooooo0_l0000Booooo`;o00002Oooool2o`0000Oooooo0_l00005ooooo`?o00000oooool3o`00
05Gooooo1ol0000Wooooo`002?ooool3o`0005;ooooo00Co0000ooooool0003o00003oooool2o`00
00[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`?o00000oooool3o`00
05_ooooo1ol0000Tooooo`001_ooool2o`0005Cooooo00Co0000oooooooooooo00003_ooool2o`00
00[ooooo0_l00007ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
063ooooo1_l0000Qooooo`00Foooool01Ol0003ooooooooooooooooo000000cooooo0_l0000;oooo
o`03o`000?oooooooooo00Gooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo0_l0001Woooo
o`Go00007_ooool005Wooooo0_l00004ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool02Oooool2o`0000Kooooo0_l00005ooooo`;o00001?ooool00ol0003oooooooooo`1Zooooo`Go
00006oooool005Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`07ooooo`;o0000
2oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0_ooool2o`00077ooooo1Ol0000Gooooo`00Eoooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool02Oooool2o`0000Oooooo00?o0000ooooooooool00ooo
ool2o`0000Cooooo00?o0000ooooooooool0M?ooool5o`0001Cooooo001Fooooo`03o`000?oooooo
oooo00Kooooo0_l00006ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0N?ooool5
o`00017ooooo001Dooooo`;o00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool01Oooool2o`0000Gooooo00?o0000ooooooooool00_ooool2o`00
07kooooo1Ol0000>ooooo`00Doooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?o
oooo0_l00004ooooo`03o`000?oooooooooo083ooooo1_l0000;ooooo`00D_ooool00ol0003ooooo
ooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo
0_l00026ooooo`Ko00002?ooool0057ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`04ooooo`05o`000?ooooooooooooooool000002oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`29ooooo`Go0000
1_ooool0053ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`04o`000?oo
ooooooooo`0000_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0SOooool00ol0003oooooooooo`05ooooo`00Cooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Cooooo0ol0000;ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo09Kooooo001>ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool2
o`0000_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0U_ooool004gooooo00?o0000ooooooooool01oooool2o`00
00Kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Gooooo`00C?ooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2Hooooo`00Boooool00ol0003oooooooooo`0@ooooo`;o00002_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`2Iooooo`00B_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo000000Wooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0V_ooool004Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`02
o`0000Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0Voooool004Wooooo00?o0000ooooooooool04?ooool01?l0
003oooooooooool00007ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo09_ooooo0018ooooo`03o`000?oooooooooo
013ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo09cooooo0017oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo09gooooo0016ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo09kooooo0016ooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool00oooool2o`0000?ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
W_ooool004Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`05o`000?oo
ooooooooooooool000001oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0Woooool004Cooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`05ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0X?ooool004?ooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:7ooooo0013ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool01_ooool00ol0003oooooo`000007ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Qooooo`00@_ooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo0_l00008ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Rooooo`00@Oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo0_l00007ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Sooooo`00@Oooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Xoooool0043ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`08ooooo`;o00001oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Y?ooool003oooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`;o00001_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Y?ooool003kooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000Kooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:Gooooo000noooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003oooooo`000005oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Voooo
o`00?Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool00_l00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2Vooooo`00?Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo
00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool0Yoooool003cooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`09ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0Yoooool003cooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`09ooooo`05o`000?ooooooooooooooool000000oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Z?ooool003_ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`05ooooo`Go00001?ooool01?l0003ooooo
ooooool00006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Z?ooool003_ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000Co
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0:Wooooo000kooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02?ooool2o`0000Go
oooo0ol00006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0ZOooool003[ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo
0_l00006ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Z_ooool003[ooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`07ooooo`05o`000?oooooo0000ooooool00000
1?ooool2o`0000Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Zooooo`00>Ooo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooool0003ooooo
o`000004ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`2[ooooo`00>Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo0ol0
0005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`2[ooooo`00>?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool01?ooool2o`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2/
ooooo`00>?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01Oooool3o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2/oooo
o`00=oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool01Oooool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2]ooooo`00
=oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1Oooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
[Oooool003Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo0:gooooo000fooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`2^ooooo`00=_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool01Oooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0[_ooool003Gooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_l00000
0ooooooo0000ooooo`03ooooo`03o`000?oooooooooo0:oooooo000eooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooo
ooooool000000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:oooooo000doooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05oooo
o`07o`000?ooooooooooooooool0003oooooo`000005ooooo`03o`000?oooooooooo0:oooooo000d
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06
ooooo`07o`000?ooooooooooooooool0003oooooo`000004ooooo`03o`000?oooooooooo0;3ooooo
000cooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00;ooooo0_l00005ooooo`03o`000?oooooooooo0;3ooooo000c
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`03o`000?oooooooooo0;7ooooo000boooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00?ooooo0_l00004ooooo`03o`000?oooooooooo0;7ooooo000booooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2aooooo`00
<_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
/_ooool0037ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool2o`0000Cooooo00?o0000ooooooooool0/_oo
ool0037ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool00oooool2o`0000Cooooo00?o0000ooooooooool0/_ooool0
037ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool00oooool2o`0000?ooooo00?o0000ooooooooool0/oooool0033o
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00oooool01?l0003oooooo`000?l00002ooooo`03o`000?oooooooooo
0;?ooooo000`ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`2dooooo`00;oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooooooool0]?ooool002oooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Gooooo1?l00002ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool0]?ooool002oooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo00Kooooo00Oo0000ooooooooooooooooo`000?oooooo000000;o
oooo00?o0000ooooool00000]oooool002kooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooo00000;Oooooo000^ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;o000000?o
ooooo`000?ooool00_ooool3o`000;Oooooo000^ooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo0_l00003
ooooo`;o0000^?ooool002gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooool000000oooool2o`0000?ooooo0_l0002hoooo
o`00;Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04o`0000Cooooo00?o0000ooooooooool0]oooool002gooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0;Oooooo
000/ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool2o`000;Wooooo0000
\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-1.07832, -2.66368, \
0.0112411, 0.0338153}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Exercises"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "(1) Make a different table of solution using a different  range of values \
of c. \n[The range {c, -3,3} would use an implicit step of 1 and produce the \
values {-3, -2, -1, 0, 1, 2, 3}; the range expression {c, -3,3,1/2} imposes \
an explicit step of 1/2, which would produce the values {-3, -5/2, -2, -3/2, \
-1, -1/2, 0, 1/2, 1, 3/2, 2, 5/2, 3}.]\n\n(2) Do the exercises 3.1 by making \
appropriate changes to the definitions of p[x_] and q[x_] in the example \
above. If you wish to create your own notebook in which to do this, ",
  StyleBox["Select",
    FontWeight->"Bold"],
  " all of the cells in the Example, ",
  StyleBox["Copy",
    FontWeight->"Bold"],
  " all of these cells, create a new empty notebook, and ",
  StyleBox["Paste",
    FontWeight->"Bold"],
  " the cells into the new notebook. Change the definitions of p[x] and q[x], \
and Execute all of the cells in the example. (Only the ",
  StyleBox["Active",
    FontSlant->"Italic"],
  " cells will actually execute.) This will produce and check the solution to \
the differential equation that you defined."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{625, 361},
WindowMargins->{{4, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 93, 2, 108, "Title",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1894, 59, 83, 2, 56, "Section",
  Evaluatable->False],
Cell[1980, 63, 2581, 76, 345, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4598, 144, 109, 2, 36, "Section",
  Evaluatable->False],
Cell[4710, 148, 794, 21, 140, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[5541, 174, 555, 21, 36, "Section",
  Evaluatable->False],
Cell[6099, 197, 153, 5, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6277, 206, 68, 2, 27, "Input"],
Cell[6348, 210, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6420, 216, 71, 2, 29, "Input"],
Cell[6494, 220, 38, 1, 29, "Output"]
}, Closed]],
Cell[6547, 224, 302, 9, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6874, 237, 239, 7, 27, "Input"],
Cell[7116, 246, 211, 6, 29, "Output"]
}, Closed]],
Cell[7342, 255, 123, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7490, 261, 92, 2, 41, "Input"],
Cell[7585, 265, 38, 1, 27, "Output"]
}, Closed]],
Cell[7638, 269, 125, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7788, 275, 106, 2, 41, "Input"],
Cell[7897, 279, 59, 1, 29, "Output"]
}, Closed]],
Cell[7971, 283, 184, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8180, 294, 120, 3, 41, "Input"],
Cell[8303, 299, 113, 2, 45, "Output"]
}, Closed]],
Cell[8431, 304, 354, 11, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8810, 319, 93, 2, 44, "Input"],
Cell[8906, 323, 106, 2, 45, "Output"]
}, Closed]],
Cell[9027, 328, 177, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9229, 336, 206, 6, 27, "Input"],
Cell[9438, 344, 197, 3, 45, "Output"]
}, Closed]],
Cell[9650, 350, 199, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9874, 358, 251, 7, 27, "Input"],
Cell[10128, 367, 38, 1, 29, "Output"]
}, Closed]],
Cell[10181, 371, 312, 11, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10518, 386, 297, 8, 27, "Input"],
Cell[10818, 396, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10893, 402, 120, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11016, 406, 104, 2, 42, "Input"],

Cell[CellGroupData[{
Cell[11145, 412, 92, 2, 27, "Input"],
Cell[11240, 416, 42148, 1169, 183, 11637, 786, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[53391, 1587, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[53582, 1597, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[53671, 1601, 1160, 24, 194, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

